#!/usr/bin/env python
from mpl_toolkits import mplot3d

import numpy as np
import matplotlib.pyplot as plt


q = np.loadtxt('resultsR/solvekin_q.res')


fig = plt.figure(figsize=(14, 4.5))
ax = plt.axes(projection='3d')

ax.plot3D(q[:,1], q[:,2], q[:,3], 'gray')
ax.set_xlabel('x [m]')
ax.set_ylabel('y [m]')
ax.set_zlabel('z [m]')
plt.title('Inverse kinematics: platform trajectory')
plt.show()


plt.figure(figsize=(14, 4.5))
plt.plot(q[:,0], q[:,10], label="10")
plt.plot(q[:,0], q[:,15], label="15")
plt.plot(q[:,0], q[:,20], label="20")
plt.xlabel('Time [s]')
plt.ylabel('Position [rad]')
plt.title('Inverse kinematics: actuator angles')
plt.legend()

Qa = np.loadtxt('resultsR/invdyn_Qa.res')

plt.figure(figsize=(7, 4.5))
plt.plot(Qa[:,0], Qa[:,10], label="10")
plt.plot(Qa[:,0], Qa[:,15], label="15")
plt.plot(Qa[:,0], Qa[:,20], label="20")
plt.xlabel('Time [s]')
plt.ylabel('Inverse dynamics: actuator torques [Nm]')
plt.legend()
plt.show()
